/**
* \file: msd_metadata.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_BACKENDS_MSD_METDATA_H
#define AAM_BACKENDS_MSD_METDATA_H

#include <stdbool.h>
#include <libudev.h>

#include "model/device.h"
#include "model/device_metadata.h"
#include "model/partition_metadata.h"
#include "backends/msd_events.h"

#define PARTITION_CNT_UNSET -1

//--------------------------------- msd type check --------------------------------------------------------
bool msd_partition_check_handler_type(partition_t *partition);

bool msd_device_check_handler_type(device_t *device);
//--------------------------------------------------------------------------------------------------------


//--------------------------------- partition metadata ----------------------------------------------------
error_code_t msd_metadata_create_for_partition(partition_metadata_t **metadata_ptr,
		msd_uevent_info_cache_t *uevent_info_cache, partition_unsupported_reason_t *unsupported_reason_ptr);

error_code_t msd_metadata_create_for_blacklisted_partition(partition_metadata_t **metadata_ptr,
		msd_uevent_info_cache_t *uevent_info_cache, partition_unsupported_reason_t *unsupported_reason_ptr);
//--------------------------------------------------------------------------------------------------------


//--------------------------------- device metadata ----------------------------------------------------
error_code_t msd_metadata_create_for_device(device_metadata_t **metadata_ptr,
		msd_uevent_info_cache_t *uevent_info_cache);
//--------------------------------------------------------------------------------------------------------

//---------------------------------- read out device specifics--------------------------------------------
/*int msd_metadata_determine_partition_count(struct udev_device *udevice);

bool msd_metadata_device_contains_partitiontable(struct udev_device *udevice);

bool msd_metadata_device_contains_filesystem(struct udev_device *udevice);*/

void msd_metadata_create_mountpoint_from_partition(msd_uevent_info_cache_t *uevent_info_cache,
		char *mount_point, size_t buf_len);

struct udev_device *msd_metadata_find_udevice_by_devnode(struct udev *udev,const char *dev_node);

struct udev_device *msd_metadata_determine_parent_device(struct udev_device *upartition);

/*bool msd_metadata_check_contains_audio_cdda(struct udev_device *upartition);*/

int msd_metadata_get_intvalue_from_udevice_property(struct udev_device *udevice,
		const char *property_name, int default_val);

const char *msd_metadata_get_value_from_udevice_property_or_default(struct udev_device *udevice,
		const char *property_name, const char *default_val);
//--------------------------------------------------------------------------------------------------------

#endif
